"use strict";
var WER = require("./build/Release/WerAPIWin.node");
var fs = require("fs");
(function (WerReportType) {
    WerReportType[WerReportType["NonCritical"] = 0] = "NonCritical";
    WerReportType[WerReportType["Critical"] = 1] = "Critical";
    WerReportType[WerReportType["AppCrash"] = 2] = "AppCrash";
    WerReportType[WerReportType["AppHang"] = 3] = "AppHang";
    WerReportType[WerReportType["Invalid"] = 5] = "Invalid";
})(exports.WerReportType || (exports.WerReportType = {}));
var WerReportType = exports.WerReportType;
(function (WerFileType) {
    WerFileType[WerFileType["Other"] = 5] = "Other";
    WerFileType[WerFileType["UserDoc"] = 4] = "UserDoc";
})(exports.WerFileType || (exports.WerFileType = {}));
var WerFileType = exports.WerFileType;
(function (WerConsent) {
    WerConsent[WerConsent["WerConsentNotAsked"] = 1] = "WerConsentNotAsked";
    WerConsent[WerConsent["WerConsentApproved"] = 2] = "WerConsentApproved";
    WerConsent[WerConsent["WerConsentDenied"] = 3] = "WerConsentDenied";
    WerConsent[WerConsent["WerConsentAlwaysPrompt"] = 4] = "WerConsentAlwaysPrompt";
    WerConsent[WerConsent["WerConsentMax"] = 5] = "WerConsentMax";
})(exports.WerConsent || (exports.WerConsent = {}));
var WerConsent = exports.WerConsent;
(function (WerSubmitFlags) {
    WerSubmitFlags[WerSubmitFlags["WER_SUBMIT_HONOR_RECOVERY"] = 1] = "WER_SUBMIT_HONOR_RECOVERY";
    WerSubmitFlags[WerSubmitFlags["WER_SUBMIT_HONOR_RESTART"] = 2] = "WER_SUBMIT_HONOR_RESTART";
    WerSubmitFlags[WerSubmitFlags["WER_SUBMIT_QUEUE"] = 4] = "WER_SUBMIT_QUEUE";
    WerSubmitFlags[WerSubmitFlags["WER_SUBMIT_SHOW_DEBUG"] = 8] = "WER_SUBMIT_SHOW_DEBUG";
    WerSubmitFlags[WerSubmitFlags["WER_SUBMIT_ADD_REGISTERED_DATA"] = 16] = "WER_SUBMIT_ADD_REGISTERED_DATA";
    WerSubmitFlags[WerSubmitFlags["WER_SUBMIT_OUTOFPROCESS"] = 32] = "WER_SUBMIT_OUTOFPROCESS";
    WerSubmitFlags[WerSubmitFlags["WER_SUBMIT_NO_CLOSE_UI"] = 64] = "WER_SUBMIT_NO_CLOSE_UI";
    WerSubmitFlags[WerSubmitFlags["WER_SUBMIT_NO_QUEUE"] = 128] = "WER_SUBMIT_NO_QUEUE";
    WerSubmitFlags[WerSubmitFlags["WER_SUBMIT_NO_ARCHIVE"] = 256] = "WER_SUBMIT_NO_ARCHIVE";
    WerSubmitFlags[WerSubmitFlags["WER_SUBMIT_START_MINIMIZED"] = 512] = "WER_SUBMIT_START_MINIMIZED";
    WerSubmitFlags[WerSubmitFlags["WER_SUBMIT_OUTOFPROCESS_ASYNC"] = 1024] = "WER_SUBMIT_OUTOFPROCESS_ASYNC";
    WerSubmitFlags[WerSubmitFlags["WER_SUBMIT_BYPASS_DATA_THROTTLING"] = 2048] = "WER_SUBMIT_BYPASS_DATA_THROTTLING";
    WerSubmitFlags[WerSubmitFlags["WER_SUBMIT_ARCHIVE_PARAMETERS_ONLY"] = 4096] = "WER_SUBMIT_ARCHIVE_PARAMETERS_ONLY";
    WerSubmitFlags[WerSubmitFlags["WER_SUBMIT_REPORT_MACHINE_ID"] = 8192] = "WER_SUBMIT_REPORT_MACHINE_ID";
    WerSubmitFlags[WerSubmitFlags["WER_SUBMIT_BYPASS_POWER_THROTTLING"] = 16384] = "WER_SUBMIT_BYPASS_POWER_THROTTLING";
    WerSubmitFlags[WerSubmitFlags["WER_SUBMIT_BYPASS_NETWORK_COST_THROTTLING"] = 32768] = "WER_SUBMIT_BYPASS_NETWORK_COST_THROTTLING";
})(exports.WerSubmitFlags || (exports.WerSubmitFlags = {}));
var WerSubmitFlags = exports.WerSubmitFlags;
function CreateWerReport(eventType, reportType, consent, submitFlags, files, params) {
    if (!files) {
        files = [];
    }
    if (!params) {
        params = [];
    }
    for (var i = 0; i < params.length; i++) {
        if (params[i].paramNumber > 9 || params[i].paramNumber < 0) {
            throw new RangeError("invalid Watson parameter number. Please use 0-9 inclusive.");
        }
        if (params[i].paramName.length > 255) {
            throw new Error("param name is too long");
        }
        if (params[i].paramValue.length > 255) {
            throw new Error("param value is too long");
        }
    }
    for (var i = 0; i < files.length; i++) {
        try {
            fs.accessSync(files[i].path, fs.R_OK);
        }
        catch (e) {
            files[i].path = "";
        }
    }
    if (eventType.length > 255) {
        throw new Error("event type is too long");
    }
    WER.createReport(eventType, reportType, files, params, consent, submitFlags);
}
exports.CreateWerReport = CreateWerReport;

// SIG // Begin signature block
// SIG // MIIiNAYJKoZIhvcNAQcCoIIiJTCCIiECAQExDzANBglg
// SIG // hkgBZQMEAgEFADB3BgorBgEEAYI3AgEEoGkwZzAyBgor
// SIG // BgEEAYI3AgEeMCQCAQEEEBDgyQbOONQRoqMAEEvTUJAC
// SIG // AQACAQACAQACAQACAQAwMTANBglghkgBZQMEAgEFAAQg
// SIG // FLHqIjuxrQi7J0REVoIOy7R/Vs4K4WMOyYX+oXhPSE2g
// SIG // gguEMIIFDDCCA/SgAwIBAgITMwAAAU/nxmLJRvSpfwAA
// SIG // AAABTzANBgkqhkiG9w0BAQsFADB+MQswCQYDVQQGEwJV
// SIG // UzETMBEGA1UECBMKV2FzaGluZ3RvbjEQMA4GA1UEBxMH
// SIG // UmVkbW9uZDEeMBwGA1UEChMVTWljcm9zb2Z0IENvcnBv
// SIG // cmF0aW9uMSgwJgYDVQQDEx9NaWNyb3NvZnQgQ29kZSBT
// SIG // aWduaW5nIFBDQSAyMDEwMB4XDTE2MTExNzIxNTkxNFoX
// SIG // DTE4MDIxNzIxNTkxNFowgYMxCzAJBgNVBAYTAlVTMRMw
// SIG // EQYDVQQIEwpXYXNoaW5ndG9uMRAwDgYDVQQHEwdSZWRt
// SIG // b25kMR4wHAYDVQQKExVNaWNyb3NvZnQgQ29ycG9yYXRp
// SIG // b24xDTALBgNVBAsTBE1PUFIxHjAcBgNVBAMTFU1pY3Jv
// SIG // c29mdCBDb3Jwb3JhdGlvbjCCASIwDQYJKoZIhvcNAQEB
// SIG // BQADggEPADCCAQoCggEBALSJkIp2DKzFPaG8gejXUAi7
// SIG // WmmnrsfMuFu9OA8hUUYII9G9Iplztyjv9werK/lI96UU
// SIG // BalNJBttYZacg50zwCx5mfBd8+zVRN+lzVn6dq0GP8ZK
// SIG // A+bqLZQQwmZv/WLQUIrRIpEjl2U0ocSaAl6S4rh8KHjC
// SIG // XuNG98rvOFeIrFYGWMqYG8eo1142rppFMOO2tz0Ywqcn
// SIG // sHlNU9gy5najUCr2P7q7QR4khk2Ym3qe9izivJBgZfuW
// SIG // afrgE2jiiSoudRidwm24IfSZXip/MaCnDczvTxFu/klC
// SIG // TmHeN8srnkDvzqtecAhzpXJ7t0bOWzJTXYo5UW+w16h4
// SIG // 3aMob17uQh8CAwEAAaOCAXswggF3MB8GA1UdJQQYMBYG
// SIG // CisGAQQBgjc9BgEGCCsGAQUFBwMDMB0GA1UdDgQWBBSS
// SIG // DqERcbYvVQ3DD/TJXHQuWgxqvzBSBgNVHREESzBJpEcw
// SIG // RTENMAsGA1UECxMETU9QUjE0MDIGA1UEBRMrMjMwODY1
// SIG // K2I0YjEyODc4LWUyOTMtNDNlOS1iMjFlLTdkMzA3MTlk
// SIG // NDUyZjAfBgNVHSMEGDAWgBTm/F97uyIAWORyTrX0IXQj
// SIG // MubvrDBWBgNVHR8ETzBNMEugSaBHhkVodHRwOi8vY3Js
// SIG // Lm1pY3Jvc29mdC5jb20vcGtpL2NybC9wcm9kdWN0cy9N
// SIG // aWNDb2RTaWdQQ0FfMjAxMC0wNy0wNi5jcmwwWgYIKwYB
// SIG // BQUHAQEETjBMMEoGCCsGAQUFBzAChj5odHRwOi8vd3d3
// SIG // Lm1pY3Jvc29mdC5jb20vcGtpL2NlcnRzL01pY0NvZFNp
// SIG // Z1BDQV8yMDEwLTA3LTA2LmNydDAMBgNVHRMBAf8EAjAA
// SIG // MA0GCSqGSIb3DQEBCwUAA4IBAQARwLlqQzX+hbE4gA24
// SIG // dHUsjXFJuDxB7S294gY2kHYrieW2gemG4xiMlpMyQqen
// SIG // 9rc0JTnQxnpD6tt3cMzU6ULrqMVVAnV4ntgQvgcbypRj
// SIG // +zwPce7UVWfXKfZqvwe85Y+C6vih4nMzPxSSXqG6ZVc3
// SIG // RYWAXNYsxos8aoejBxHL7NlxOCA1JD1UvcxVifR3EJvl
// SIG // maoPrsY8jp/aAE/PfeGzwCD3UjH3IkjVYY1/JgIZfYPM
// SIG // YZMq3bjc4gizp9/hBHdgyPSsNcsx5Wx1UcU3exNqTpVr
// SIG // j0CeyE0+rr1ZxSDWwnitt2RbO9DAFXA0FOXFnqYcx/T/
// SIG // 9stIweKN827OqrSgMIIGcDCCBFigAwIBAgIKYQxSTAAA
// SIG // AAAAAzANBgkqhkiG9w0BAQsFADCBiDELMAkGA1UEBhMC
// SIG // VVMxEzARBgNVBAgTCldhc2hpbmd0b24xEDAOBgNVBAcT
// SIG // B1JlZG1vbmQxHjAcBgNVBAoTFU1pY3Jvc29mdCBDb3Jw
// SIG // b3JhdGlvbjEyMDAGA1UEAxMpTWljcm9zb2Z0IFJvb3Qg
// SIG // Q2VydGlmaWNhdGUgQXV0aG9yaXR5IDIwMTAwHhcNMTAw
// SIG // NzA2MjA0MDE3WhcNMjUwNzA2MjA1MDE3WjB+MQswCQYD
// SIG // VQQGEwJVUzETMBEGA1UECBMKV2FzaGluZ3RvbjEQMA4G
// SIG // A1UEBxMHUmVkbW9uZDEeMBwGA1UEChMVTWljcm9zb2Z0
// SIG // IENvcnBvcmF0aW9uMSgwJgYDVQQDEx9NaWNyb3NvZnQg
// SIG // Q29kZSBTaWduaW5nIFBDQSAyMDEwMIIBIjANBgkqhkiG
// SIG // 9w0BAQEFAAOCAQ8AMIIBCgKCAQEA6Q5kUHlntcTj/QkA
// SIG // TJ6UrPdWaOpE2M/FWE+ppXZ8bUW60zmStKQe+fllguQX
// SIG // 0o/9RJwI6GWTzixVhL99COMuK6hBKxi3oktuSUxrFQfe
// SIG // 0dLCiR5xlM21f0u0rwjYzIjWaxeUOpPOJj/s5v40mFfV
// SIG // HV1J9rIqLtWFu1k/+JC0K4N0yiuzO0bj8EZJwRdmVMkc
// SIG // vR3EVWJXcvhnuSUgNN5dpqWVXqsogM3Vsp7lA7Vj07IU
// SIG // yMHIiiYKWX8H7P8O7YASNUwSpr5SW/Wm2uCLC0h31oVH
// SIG // 1RC5xuiq7otqLQVcYMa0KlucIxxfReMaFB5vN8sZM4Bq
// SIG // iU2jamZjeJPVMM+VHwIDAQABo4IB4zCCAd8wEAYJKwYB
// SIG // BAGCNxUBBAMCAQAwHQYDVR0OBBYEFOb8X3u7IgBY5HJO
// SIG // tfQhdCMy5u+sMBkGCSsGAQQBgjcUAgQMHgoAUwB1AGIA
// SIG // QwBBMAsGA1UdDwQEAwIBhjAPBgNVHRMBAf8EBTADAQH/
// SIG // MB8GA1UdIwQYMBaAFNX2VsuP6KJcYmjRPZSQW9fOmhjE
// SIG // MFYGA1UdHwRPME0wS6BJoEeGRWh0dHA6Ly9jcmwubWlj
// SIG // cm9zb2Z0LmNvbS9wa2kvY3JsL3Byb2R1Y3RzL01pY1Jv
// SIG // b0NlckF1dF8yMDEwLTA2LTIzLmNybDBaBggrBgEFBQcB
// SIG // AQROMEwwSgYIKwYBBQUHMAKGPmh0dHA6Ly93d3cubWlj
// SIG // cm9zb2Z0LmNvbS9wa2kvY2VydHMvTWljUm9vQ2VyQXV0
// SIG // XzIwMTAtMDYtMjMuY3J0MIGdBgNVHSAEgZUwgZIwgY8G
// SIG // CSsGAQQBgjcuAzCBgTA9BggrBgEFBQcCARYxaHR0cDov
// SIG // L3d3dy5taWNyb3NvZnQuY29tL1BLSS9kb2NzL0NQUy9k
// SIG // ZWZhdWx0Lmh0bTBABggrBgEFBQcCAjA0HjIgHQBMAGUA
// SIG // ZwBhAGwAXwBQAG8AbABpAGMAeQBfAFMAdABhAHQAZQBt
// SIG // AGUAbgB0AC4gHTANBgkqhkiG9w0BAQsFAAOCAgEAGnTv
// SIG // V08pe8QWhXi4UNMi/AmdrIKX+DT/KiyXlRLl5L/Pv5PI
// SIG // 4zSp24G43B4AvtI1b6/lf3mVd+UC1PHr2M1OHhthosJa
// SIG // IxrwjKhiUUVnCOM/PB6T+DCFF8g5QKbXDrMhKeWloWmM
// SIG // IpPMdJjnoUdD8lOswA8waX/+0iUgbW9h098H1dlyACxp
// SIG // hnY9UdumOUjJN2FtB91TGcun1mHCv+KDqw/ga5uV1n0o
// SIG // UbCJSlGkmmzItx9KGg5pqdfcwX7RSXCqtq27ckdjF/qm
// SIG // 1qKmhuyoEESbY7ayaYkGx0aGehg/6MUdIdV7+QIjLcVB
// SIG // y78dTMgW77Gcf/wiS0mKbhXjpn92W9FTeZGFndXS2z1z
// SIG // NfM8rlSyUkdqwKoTldKOEdqZZ14yjPs3hdHcdYWch8Za
// SIG // V4XCv90Nj4ybLeu07s8n07VeafqkFgQBpyRnc89NT7be
// SIG // BVaXevfpUk30dwVPhcbYC/GO7UIJ0Q124yNWeCImNr7K
// SIG // sYxuqh3khdpHM2KPpMmRM19xHkCvmGXJIuhCISWKHC1g
// SIG // 2TeJQYkqFg/XYTyUaGBS79ZHmaCAQO4VgXc+nOBTGBpQ
// SIG // HTiVmx5mMxMnORd4hzbOTsNfsvU9R1O24OXbC2E9KteS
// SIG // LM43Wj5AQjGkHxAIwlacvyRdUQKdannSF9PawZSOB3sl
// SIG // cUSrBmrm1MbfI5qWdcUxghYIMIIWBAIBATCBlTB+MQsw
// SIG // CQYDVQQGEwJVUzETMBEGA1UECBMKV2FzaGluZ3RvbjEQ
// SIG // MA4GA1UEBxMHUmVkbW9uZDEeMBwGA1UEChMVTWljcm9z
// SIG // b2Z0IENvcnBvcmF0aW9uMSgwJgYDVQQDEx9NaWNyb3Nv
// SIG // ZnQgQ29kZSBTaWduaW5nIFBDQSAyMDEwAhMzAAABT+fG
// SIG // YslG9Kl/AAAAAAFPMA0GCWCGSAFlAwQCAQUAoIHzMBkG
// SIG // CSqGSIb3DQEJAzEMBgorBgEEAYI3AgEEMBwGCisGAQQB
// SIG // gjcCAQsxDjAMBgorBgEEAYI3AgEVMC8GCSqGSIb3DQEJ
// SIG // BDEiBCBacvTiy8XRBp8PI1O3fe1CDFMx/7rkkAYtew/g
// SIG // nFe49DCBhgYKKwYBBAGCNwIBDDF4MHagXIBaAGkAbgBk
// SIG // AGUAeABfAGUANwA3AGYANwA3ADUAMQAtAGEANgBiAGEA
// SIG // LQA0ADIAYwBiAC0AOQAwADUAOQAtAGEAMQBlADYANAA3
// SIG // AGQAMwBkADIAYgA3AC4AagBzoRaAFGh0dHA6Ly9taWNy
// SIG // b3NvZnQuY29tMA0GCSqGSIb3DQEBAQUABIIBAKocf/C7
// SIG // L/w4CgGw6yDB5x+XGFq4ud5ziGKgqN3nQQqikAX4UcPm
// SIG // dOwFdhJlTTEbBGx4nAG2KkU7/vdbp1U4hVRPGwU03FoJ
// SIG // VDpLTyK7g15CTRNJ8V5xKxhlzHq/tEpa6MWIeQ1Gro/7
// SIG // iC8TOcwcJ8BtwEpQMz8LZSSDiNAOjvmaf/3nJ9Z0UDEH
// SIG // ZKsUB/JEZIq0Y+cuUsyjbe9SMO7nr2Waks16HqoViZxh
// SIG // FpoNUQFKTYLUpvuWxnXDu0lOxLxrTDEd3yMV9nM9dytK
// SIG // tCcvrJEZIWYzXbriJqYmc2eNuk842n3oOrsGaT/rwR5B
// SIG // WqDnT2QWuNNNbqPusjbPh09veEahghNNMIITSQYKKwYB
// SIG // BAGCNwMDATGCEzkwghM1BgkqhkiG9w0BBwKgghMmMIIT
// SIG // IgIBAzEPMA0GCWCGSAFlAwQCAQUAMIIBPQYLKoZIhvcN
// SIG // AQkQAQSgggEsBIIBKDCCASQCAQEGCisGAQQBhFkKAwEw
// SIG // MTANBglghkgBZQMEAgEFAAQg1v42iLldhXIzaPd9nvKj
// SIG // Mvsu9ZF2AneTlCCo1y4eWnoCBlg/QcsqsBgTMjAxNjEy
// SIG // MjgwMDU4MDkuNTc4WjAHAgEBgAIB9KCBuaSBtjCBszEL
// SIG // MAkGA1UEBhMCVVMxEzARBgNVBAgTCldhc2hpbmd0b24x
// SIG // EDAOBgNVBAcTB1JlZG1vbmQxHjAcBgNVBAoTFU1pY3Jv
// SIG // c29mdCBDb3Jwb3JhdGlvbjENMAsGA1UECxMETU9QUjEn
// SIG // MCUGA1UECxMebkNpcGhlciBEU0UgRVNOOkJCRUMtMzBD
// SIG // QS0yREJFMSUwIwYDVQQDExxNaWNyb3NvZnQgVGltZS1T
// SIG // dGFtcCBTZXJ2aWNloIIO0DCCBnEwggRZoAMCAQICCmEJ
// SIG // gSoAAAAAAAIwDQYJKoZIhvcNAQELBQAwgYgxCzAJBgNV
// SIG // BAYTAlVTMRMwEQYDVQQIEwpXYXNoaW5ndG9uMRAwDgYD
// SIG // VQQHEwdSZWRtb25kMR4wHAYDVQQKExVNaWNyb3NvZnQg
// SIG // Q29ycG9yYXRpb24xMjAwBgNVBAMTKU1pY3Jvc29mdCBS
// SIG // b290IENlcnRpZmljYXRlIEF1dGhvcml0eSAyMDEwMB4X
// SIG // DTEwMDcwMTIxMzY1NVoXDTI1MDcwMTIxNDY1NVowfDEL
// SIG // MAkGA1UEBhMCVVMxEzARBgNVBAgTCldhc2hpbmd0b24x
// SIG // EDAOBgNVBAcTB1JlZG1vbmQxHjAcBgNVBAoTFU1pY3Jv
// SIG // c29mdCBDb3Jwb3JhdGlvbjEmMCQGA1UEAxMdTWljcm9z
// SIG // b2Z0IFRpbWUtU3RhbXAgUENBIDIwMTAwggEiMA0GCSqG
// SIG // SIb3DQEBAQUAA4IBDwAwggEKAoIBAQCpHQ28dxGKOiDs
// SIG // /BOX9fp/aZRrdFQQ1aUKAIKF++18aEssX8XD5WHCdrc+
// SIG // Zitb8BVTJwQxH0EbGpUdzgkTjnxhMFmxMEQP8WCIhFRD
// SIG // DNdNuDgIs0Ldk6zWczBXJoKjRQ3Q6vVHgc2/JGAyWGBG
// SIG // 8lhHhjKEHnRhZ5FfgVSxz5NMksHEpl3RYRNuKMYa+YaA
// SIG // u99h/EbBJx0kZxJyGiGKr0tkiVBisV39dx898Fd1rL2K
// SIG // Qk1AUdEPnAY+Z3/1ZsADlkR+79BL/W7lmsqxqPJ6Kgox
// SIG // 8NpOBpG2iAg16HgcsOmZzTznL0S6p/TcZL2kAcEgCZN4
// SIG // zfy8wMlEXV4WnAEFTyJNAgMBAAGjggHmMIIB4jAQBgkr
// SIG // BgEEAYI3FQEEAwIBADAdBgNVHQ4EFgQU1WM6XIoxkPND
// SIG // e3xGG8UzaFqFbVUwGQYJKwYBBAGCNxQCBAweCgBTAHUA
// SIG // YgBDAEEwCwYDVR0PBAQDAgGGMA8GA1UdEwEB/wQFMAMB
// SIG // Af8wHwYDVR0jBBgwFoAU1fZWy4/oolxiaNE9lJBb186a
// SIG // GMQwVgYDVR0fBE8wTTBLoEmgR4ZFaHR0cDovL2NybC5t
// SIG // aWNyb3NvZnQuY29tL3BraS9jcmwvcHJvZHVjdHMvTWlj
// SIG // Um9vQ2VyQXV0XzIwMTAtMDYtMjMuY3JsMFoGCCsGAQUF
// SIG // BwEBBE4wTDBKBggrBgEFBQcwAoY+aHR0cDovL3d3dy5t
// SIG // aWNyb3NvZnQuY29tL3BraS9jZXJ0cy9NaWNSb29DZXJB
// SIG // dXRfMjAxMC0wNi0yMy5jcnQwgaAGA1UdIAEB/wSBlTCB
// SIG // kjCBjwYJKwYBBAGCNy4DMIGBMD0GCCsGAQUFBwIBFjFo
// SIG // dHRwOi8vd3d3Lm1pY3Jvc29mdC5jb20vUEtJL2RvY3Mv
// SIG // Q1BTL2RlZmF1bHQuaHRtMEAGCCsGAQUFBwICMDQeMiAd
// SIG // AEwAZQBnAGEAbABfAFAAbwBsAGkAYwB5AF8AUwB0AGEA
// SIG // dABlAG0AZQBuAHQALiAdMA0GCSqGSIb3DQEBCwUAA4IC
// SIG // AQAH5ohRDeLG4Jg/gXEDPZ2joSFvs+umzPUxvs8F4qn+
// SIG // +ldtGTCzwsVmyWrf9efweL3HqJ4l4/m87WtUVwgrUYJE
// SIG // Evu5U4zM9GASinbMQEBBm9xcF/9c+V4XNZgkVkt070IQ
// SIG // yK+/f8Z/8jd9Wj8c8pl5SpFSAK84Dxf1L3mBZdmptWvk
// SIG // x872ynoAb0swRCQiPM/tA6WWj1kpvLb9BOFwnzJKJ/1V
// SIG // ry/+tuWOM7tiX5rbV0Dp8c6ZZpCM/2pif93FSguRJuI5
// SIG // 7BlKcWOdeyFtw5yjojz6f32WapB4pm3S4Zz5Hfw42JT0
// SIG // xqUKloakvZ4argRCg7i1gJsiOCC1JeVk7Pf0v35jWSUP
// SIG // ei45V3aicaoGig+JFrphpxHLmtgOR5qAxdDNp9DvfYPw
// SIG // 4TtxCd9ddJgiCGHasFAeb73x4QDf5zEHpJM692VHeOj4
// SIG // qEir995yfmFrb3epgcunCaw5u+zGy9iCtHLNHfS4hQEe
// SIG // gPsbiSpUObJb2sgNVZl6h3M7COaYLeqN4DMuEin1wC9U
// SIG // JyH3yKxO2ii4sanblrKnQqLJzxlBTeCG+SqaoxFmMNO7
// SIG // dDJL32N79ZmKLxvHIa9Zta7cRDyXUHHXodLFVeNp3lfB
// SIG // 0d4wwP3M5k37Db9dT+mdHhk4L7zPWAUu7w2gUDXa7wkn
// SIG // HNWzfjUeCLraNtvTX4/edIhJEjCCBNowggPCoAMCAQIC
// SIG // EzMAAAChpf257qf8np0AAAAAAKEwDQYJKoZIhvcNAQEL
// SIG // BQAwfDELMAkGA1UEBhMCVVMxEzARBgNVBAgTCldhc2hp
// SIG // bmd0b24xEDAOBgNVBAcTB1JlZG1vbmQxHjAcBgNVBAoT
// SIG // FU1pY3Jvc29mdCBDb3Jwb3JhdGlvbjEmMCQGA1UEAxMd
// SIG // TWljcm9zb2Z0IFRpbWUtU3RhbXAgUENBIDIwMTAwHhcN
// SIG // MTYwOTA3MTc1NjQ4WhcNMTgwOTA3MTc1NjQ4WjCBszEL
// SIG // MAkGA1UEBhMCVVMxEzARBgNVBAgTCldhc2hpbmd0b24x
// SIG // EDAOBgNVBAcTB1JlZG1vbmQxHjAcBgNVBAoTFU1pY3Jv
// SIG // c29mdCBDb3Jwb3JhdGlvbjENMAsGA1UECxMETU9QUjEn
// SIG // MCUGA1UECxMebkNpcGhlciBEU0UgRVNOOkJCRUMtMzBD
// SIG // QS0yREJFMSUwIwYDVQQDExxNaWNyb3NvZnQgVGltZS1T
// SIG // dGFtcCBTZXJ2aWNlMIIBIjANBgkqhkiG9w0BAQEFAAOC
// SIG // AQ8AMIIBCgKCAQEAm9ABeeYir3p8G3Ue87dn1h3ep94A
// SIG // NNgS+QfqCHsfTU3KhZR6q3ZrKgdFjVEn07ZdRqUlxmIU
// SIG // eYtPzOYs9eyfTXodNCI2KrjD4uzFUO3T/UPBLb/F8PrP
// SIG // zISQ66Kmsm1XoI+5YXDUSc6IL4MuO4FKk7VJSsRlyZaF
// SIG // 5C/6rOLYVx0z9r4Q58JSGxPg+RQ2qLOb9NsV8PTSa30t
// SIG // uFXOEelW/5TpIQ67kVfMnBV5cM2OrNPjgZmYww4H39tz
// SIG // xc8pY/U+7DcYenP2JHW1/Mk3lDBXB9WgQBVNCxaw5tU3
// SIG // XTzY06u8h5eHelVzS2FDwfMJiJK+zrjlhEo8FjecQc4g
// SIG // l4HICQIDAQABo4IBGzCCARcwHQYDVR0OBBYEFKtcuYK+
// SIG // cSrVj+DosinP+hvTt/pIMB8GA1UdIwQYMBaAFNVjOlyK
// SIG // MZDzQ3t8RhvFM2hahW1VMFYGA1UdHwRPME0wS6BJoEeG
// SIG // RWh0dHA6Ly9jcmwubWljcm9zb2Z0LmNvbS9wa2kvY3Js
// SIG // L3Byb2R1Y3RzL01pY1RpbVN0YVBDQV8yMDEwLTA3LTAx
// SIG // LmNybDBaBggrBgEFBQcBAQROMEwwSgYIKwYBBQUHMAKG
// SIG // Pmh0dHA6Ly93d3cubWljcm9zb2Z0LmNvbS9wa2kvY2Vy
// SIG // dHMvTWljVGltU3RhUENBXzIwMTAtMDctMDEuY3J0MAwG
// SIG // A1UdEwEB/wQCMAAwEwYDVR0lBAwwCgYIKwYBBQUHAwgw
// SIG // DQYJKoZIhvcNAQELBQADggEBACNgTLgFVOlnyb45PBUy
// SIG // wxPIswCQfxczm/12L11MErPosCSi/rL0H6iyji5OEAdc
// SIG // 6Pc0iu40HejhRIb4HtvePRKUh8GaD0Pgm/oUYau26hLj
// SIG // qohq12V35Qdb0FBT0cVa1CgvKkpReR95OSp3x2HlI38q
// SIG // BdomntVAtuJf3DoTdOU6/ar7PwL8K/n4IFJbKMpdsiAo
// SIG // 7h0e9IqEvBdS6rMScZosHRtODXjR25MNJF4XiElUIfzY
// SIG // XCbQ6RPhbMpOvwe4O/nhnC9GDGU6nEWwCadzTCxrttcW
// SIG // Y+D8cjiZpgXNMpFBol76u9etDnuFy/MPdzt4MtNPlpEU
// SIG // SCPGipeXWB39pUGhggN5MIICYQIBATCB46GBuaSBtjCB
// SIG // szELMAkGA1UEBhMCVVMxEzARBgNVBAgTCldhc2hpbmd0
// SIG // b24xEDAOBgNVBAcTB1JlZG1vbmQxHjAcBgNVBAoTFU1p
// SIG // Y3Jvc29mdCBDb3Jwb3JhdGlvbjENMAsGA1UECxMETU9Q
// SIG // UjEnMCUGA1UECxMebkNpcGhlciBEU0UgRVNOOkJCRUMt
// SIG // MzBDQS0yREJFMSUwIwYDVQQDExxNaWNyb3NvZnQgVGlt
// SIG // ZS1TdGFtcCBTZXJ2aWNloiUKAQEwCQYFKw4DAhoFAAMV
// SIG // AIKuifW05j8WXCC8F+TBw0DNOetooIHCMIG/pIG8MIG5
// SIG // MQswCQYDVQQGEwJVUzETMBEGA1UECBMKV2FzaGluZ3Rv
// SIG // bjEQMA4GA1UEBxMHUmVkbW9uZDEeMBwGA1UEChMVTWlj
// SIG // cm9zb2Z0IENvcnBvcmF0aW9uMQ0wCwYDVQQLEwRNT1BS
// SIG // MScwJQYDVQQLEx5uQ2lwaGVyIE5UUyBFU046NTdGNi1D
// SIG // MUUwLTU1NEMxKzApBgNVBAMTIk1pY3Jvc29mdCBUaW1l
// SIG // IFNvdXJjZSBNYXN0ZXIgQ2xvY2swDQYJKoZIhvcNAQEF
// SIG // BQACBQDcDYU+MCIYDzIwMTYxMjI4MDAyNjM4WhgPMjAx
// SIG // NjEyMjkwMDI2MzhaMHcwPQYKKwYBBAGEWQoEATEvMC0w
// SIG // CgIFANwNhT4CAQAwCgIBAAICARQCAf8wBwIBAAICGv4w
// SIG // CgIFANwO1r4CAQAwNgYKKwYBBAGEWQoEAjEoMCYwDAYK
// SIG // KwYBBAGEWQoDAaAKMAgCAQACAxbjYKEKMAgCAQACAweh
// SIG // IDANBgkqhkiG9w0BAQUFAAOCAQEAzW8yj6RjhC7xdjBv
// SIG // oXSl4w44R2D+EHKcn++wIePpSkZ/mDwL3kV0SPGHy0+l
// SIG // 5NFoEbpf66C7Rlu8ifmwv2yhOhRzD0Sp4EkgvFNU+bm+
// SIG // ZdeBgdAP8VF79nHksM08FU4UETINaeFS/ZaA9UFQl1DH
// SIG // EvV0KFFXGRhi/4hLkIl/t7OGQexx4wNDSrnxdw0ej6iP
// SIG // Myql3zCqPmh6ACbw88cSGF1czGP2uP7mYOzVfQiOiYzH
// SIG // e3aDVGPTjSUU90rs1+qahUSHh+vyhZK+lCct8lyqxxuU
// SIG // InQD+ehiOTkU11KTfPCdQa7nD31Sjfe5gIifUBJb28Dm
// SIG // wUHz+HM8sp5UesznczGCAvUwggLxAgEBMIGTMHwxCzAJ
// SIG // BgNVBAYTAlVTMRMwEQYDVQQIEwpXYXNoaW5ndG9uMRAw
// SIG // DgYDVQQHEwdSZWRtb25kMR4wHAYDVQQKExVNaWNyb3Nv
// SIG // ZnQgQ29ycG9yYXRpb24xJjAkBgNVBAMTHU1pY3Jvc29m
// SIG // dCBUaW1lLVN0YW1wIFBDQSAyMDEwAhMzAAAAoaX9ue6n
// SIG // /J6dAAAAAAChMA0GCWCGSAFlAwQCAQUAoIIBMjAaBgkq
// SIG // hkiG9w0BCQMxDQYLKoZIhvcNAQkQAQQwLwYJKoZIhvcN
// SIG // AQkEMSIEIG7C+UJqf00XWPR2MysoXczUoHxy+jlNscTR
// SIG // 16fgshLqMIHiBgsqhkiG9w0BCRACDDGB0jCBzzCBzDCB
// SIG // sQQUgq6J9bTmPxZcILwX5MHDQM0562gwgZgwgYCkfjB8
// SIG // MQswCQYDVQQGEwJVUzETMBEGA1UECBMKV2FzaGluZ3Rv
// SIG // bjEQMA4GA1UEBxMHUmVkbW9uZDEeMBwGA1UEChMVTWlj
// SIG // cm9zb2Z0IENvcnBvcmF0aW9uMSYwJAYDVQQDEx1NaWNy
// SIG // b3NvZnQgVGltZS1TdGFtcCBQQ0EgMjAxMAITMwAAAKGl
// SIG // /bnup/yenQAAAAAAoTAWBBRLV4WfXe6QNv9iQniek3K3
// SIG // Q/9qMTANBgkqhkiG9w0BAQsFAASCAQAxWLNDAfYPWu9S
// SIG // W+FdszOYvovChxUsJKanzZOg5XRpaDJ59rfAQR4v+QlD
// SIG // ERl7JKOd1DG975t5hJxeaKpWukSz5ulwRaVioGxbQxpr
// SIG // PR1Fwn9YXYslxi8h7Kw9vIQx6ztu+PBNXmyxkL/GneK1
// SIG // /1Ls9Dr0gE0/GyjG1qsx4Q1RdnfsL8t3j0JL1yHe1SdM
// SIG // 027otX9q97+e9D7oLqyfUIJbCApbSg08AkUmGmQIQwbe
// SIG // bn5ermFnceLNDEI1Q5QECp68ZOhqOICwhtyGNfEO/S3g
// SIG // YwnE2DdHA7Y9T0YR3gUmXS0xtD3ra09cbmbHjSivvVE8
// SIG // NsFjcVw+9cMsDcR8ZBa9
// SIG // End signature block
